<?php
class GctTranslationService
{
    private $endpoint;
    private $apiKey;

    public function __construct($endpoint, $apiKey = '')
    {
        $this->endpoint = rtrim($endpoint, '/');
        $this->apiKey   = $apiKey;
    }

    /**
     * @param string $text   Teks sumber
     * @param string $source 'id' | 'en'  (opsional untuk v2)
     * @param string $target 'id' | 'en'
     * @return string translated text
     * @throws Exception
     */
    public function translate($text, $source, $target)
    {
        if ($this->apiKey === '') {
            throw new Exception('API key Google Cloud Translation belum diisi.');
        }

        $url = $this->endpoint . '?key=' . urlencode($this->apiKey);

        $payload = [
            'q'      => $text,
            'target' => $target,
            'format' => 'text',
        ];
        if ($source !== '') {
            $payload['source'] = $source;
        }

        $ch = curl_init($url);
        curl_setopt_array($ch, [
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_POST           => true,
            CURLOPT_HTTPHEADER     => ['Content-Type: application/json', 'Accept: application/json'],
            CURLOPT_POSTFIELDS     => json_encode($payload),
            CURLOPT_TIMEOUT        => defined('HTTP_TIMEOUT') ? HTTP_TIMEOUT : 12,
        ]);

        $raw = curl_exec($ch);
        if ($raw === false) {
            $err = curl_error($ch);
            curl_close($ch);
            throw new Exception('Gagal menghubungi Google Translation: ' . $err);
        }

        $status = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        curl_close($ch);

        $data = json_decode($raw, true);

        if ($status !== 200) {
            $msg = isset($data['error']['message']) ? $data['error']['message'] : ('Status HTTP ' . $status);
            throw new Exception('Terjadi kesalahan dari API: ' . $msg);
        }

        if (!isset($data['data']['translations'][0]['translatedText'])) {
            throw new Exception('Respons API tidak dikenali.');
        }

        // Catatan: Google meng-escape HTML entitas. UI kita pakai textContent → aman.
        return $data['data']['translations'][0]['translatedText'];
    }
}
