<?php
/**
 * Controller dasar untuk render view & respon JSON.
 * - render($viewPath, $data): render view ke dalam layout.
 * - json($payload, $status): kirim respon JSON.
 */
class Controller
{
    /**
     * Render view ke dalam layout utama.
     * $viewPath: path relatif dari /app/views tanpa ekstensi (mis. 'home/index')
     * $data: array variabel yang akan diekstrak ke view
     */
    protected function render($viewPath, $data = [])
    {
        // Ekstrak variabel agar tersedia di view sebagai $var
        if (is_array($data)) {
            extract($data, EXTR_SKIP);
        }

        // Tangkap output view
        ob_start();
        require __DIR__ . '/../views/' . $viewPath . '.php';
        $content = ob_get_clean();

        // Sertakan layout utama (menggunakan $content)
        require __DIR__ . '/../views/layout.php';
    }

    /**
     * Kirim JSON response dengan header & status tepat.
     */
    protected function json($payload, $status = 200)
    {
        if (!headers_sent()) {
            http_response_code((int)$status);
            header('Content-Type: application/json; charset=utf-8');
            header('X-Content-Type-Options: nosniff');
        }
        echo json_encode($payload, JSON_UNESCAPED_UNICODE);
    }
}
